#simulation of nonlinear coupling from spinwave to electrons.
from visual import *

ec = 1.6e-19

electrons = [sphere(pos=(0,-1,0), Q=ec, p=vector(0.0,.1,0.0), color=color.red, radius=.2),
             sphere(pos=(0,1,0), Q=ec, p=vector(0.0,-.1,0.0), color=color.red, radius=.2),
             ]
vectors = [arrow( pos=(0.0,-1,0.0), axis=(.001,0.0,0.0), shaftwidth = .6, color=color.blue),
           arrow( pos=(0.0,1,0.0), axis=(.001,0.0,0.0), shaftwidth = .6, color=color.blue),
           ]


scene.title = "Electron Spinwave Interaction"
scene.range = 2
        
tmax = 10000.0
dt=.001
t=0

while t<tmax:

    t += dt

    force1on2 = -1e36*electrons[0].Q*electrons[1].Q*(electrons[0].pos-electrons[1].pos)/mag(electrons[0].pos-electrons[1].pos)**3
    force2on1 = -1e36*electrons[0].Q*electrons[1].Q*(electrons[1].pos-electrons[0].pos)/mag(electrons[1].pos-electrons[0].pos)**3

    electrons[0].p += force2on1*dt
    electrons[1].p += force1on2*dt

    electrons[0].pos += electrons[0].p*dt
    electrons[1].pos += electrons[1].p*dt

    vectors[0].pos = electrons[0].pos
    vectors[0].axis = electrons[0].p*1e-1
    
    vectors[1].pos = electrons[1].pos
    vectors[1].axis = electrons[1].p*1e-1
